#!/usr/bin/webif-page
<? 
. /usr/lib/webif/webif.sh
load_settings "wireless"

CC=${wl0_country_code:-$(nvram get wl0_country_code)}
case "$CC" in
	All|all|ALL) CHANNELS="1 2 3 4 5 6 7 8 9 10 11 12 13 14"; CHANNEL_MAX=14 ;;
	*) CHANNELS="1 2 3 4 5 6 7 8 9 10 11"; CHANNEL_MAX=11 ;;
esac
F_CHANNELS="option|0|@TR<<Auto>>"
for ch in $CHANNELS; do
	F_CHANNELS="${F_CHANNELS}
option|$ch"
done

FORM_wds="${wl0_wds:-$(nvram get wl0_wds)}"
LISTVAL="$FORM_wds"
handle_list "$FORM_wdsremove" "$FORM_wdsadd" "$FORM_wdssubmit" 'mac|FORM_wdsadd|WDS MAC address|required' && {
	FORM_wds="$LISTVAL"
	save_setting wireless wl0_wds "$FORM_wds"
}
FORM_wdsadd=${FORM_wdsadd:-00:00:00:00:00:00}

if empty "$FORM_submit"; then
	FORM_mode=${wl0_mode:-$(nvram get wl0_mode)}
	infra=${wl0_infra:-$(nvram get wl0_infra)}
	case "$infra" in
		0|off|disabled) FORM_mode=adhoc;;
	esac
	FORM_radio=${wl0_radio:-$(nvram get wl0_radio)}
	case "$FORM_radio" in
		0|off|diabled) FORM_radio=0;;
		*) FORM_radio=1;;
	esac
			
	FORM_ssid=${wl0_ssid:-$(nvram get wl0_ssid)}
	case "$FORM_broadcast" in
		1|off|disabled) FORM_broadcast=1;;
		*) FORM_broadcast=0;;
	esac
	FORM_channel=${wl0_channel:-$(nvram get wl0_channel)}

	FORM_lazywds=${wl0_lazywds:-$(nvram get wl0_lazywds)}
	case "$FORM_lazywds" in
		1|on|enabled) FORM_lazywds=1;;
		*) FORM_lazywds=0;;
	esac
	FORM_lan_access="${lan_access:-$(nvram get lan_access)}"
	case "$FORM_lan_access" in
		1|on|enabled) FORM_lan_access=1;;
		*) FORM_lan_access=0;;
	esac
else
	SAVED=1

	validate <<EOF
int|FORM_radio|wl0_radio|required min=0 max=1|$FORM_radio
string|FORM_ssid|@TR<<ESSID>>|required|$FORM_ssid
int|FORM_channel|@TR<<Channel>>|required min=0 max=$CHANNEL_MAX|$FORM_channel
int|FORM_lazywds|Lazy WDS On/Off|required min=0 max=1|$FORM_lazywds
int|FORM_lan_access|LAN access|required min=0 max=1|$FORM_lan_access
EOF
	equal "$?" 0 && {
		save_setting wireless wl0_radio "$FORM_radio"
		save_setting wireless wl0_ssid "$FORM_ssid"
		save_setting wireless wl0_channel "$FORM_channel"
		save_setting wireless wl0_lazywds "$FORM_lazywds"
		save_setting wireless lan_access "$FORM_lan_access"
	}
fi

header "Network" "Wireless" "@TR<<Wireless Configuration>>" ' onLoad="modechange()" ' "$SCRIPT_NAME$PATH_INFO"

display_form <<EOF
onchange|modechange
start_form|@TR<<Wireless Configuration>>
field|@TR<<Wireless Interface>>
select|radio|$FORM_radio
option|1|@TR<<Enabled>>
option|0|@TR<<Disabled>>
field|@TR<<ESSID>>
string|FON_
text|ssid|$FORM_ssid
helpitem|ESSID
helptext|Helptext ESSID#Name of your Wireless Network
field|@TR<<Channel>>
select|channel|$FORM_channel
$F_CHANNELS
end_form
start_form|@TR<<Access Restriction>>
field|@TR<<LAN Access>>
select|lan_access|$FORM_lan_access
option|1|@TR<<Allow>>
option|0|@TR<<Deny>>
end_form
start_form|@TR<<WDS Connections>>
field|@TR<<Automatic WDS>>
select|lazywds|$FORM_lazywds
option|1|@TR<<Enabled>>
option|0|@TR<<Disabled>>
listedit|wds|$SCRIPT_NAME$PATH_INFO?|$FORM_wds|$FORM_wdsadd
end_form
EOF

footer ?>
<!--
##WEBIF:name:Network:3:Wireless
-->
