. /usr/lib/webif/webif.sh

HEADER_PLAIN=1
header "" "" "@TR<<No_network|No network access>>"

cat <<EOF
		<script type="text/javascript">
<!--
function onChange() {
	document.location.href = '$SCRIPT_NAME/lang:' + document.langForm.langSel.value;
}
-->
		</script>
		<form name="langForm">
		<div style="text-align: right; display: block; margin-left: auto">
			<select onchange="onChange()" name="langSel">
			<option value="">--- @TR<<Language>> ---</option>
			<option value="en">English</option>
			
EOF
grep '^[\t ]*lang[\t ]*=>' /usr/lib/webif/lang/*/*.txt | awk '
/webif\/lang\/[a-zA-Z][a-zA-Z]*/ {
	gsub(/^.*webif\/lang\//, "")
	shortname = $0
	gsub(/\/.*$/, "", shortname)
	gsub(/^.*=>[ \t]*/, "")
	longname = $0
	print "<option value=\"" shortname "\">" longname "</option>"
}
'
WIFI_IP="$(nvram get lan_ipaddr)"
WIFI_IP="$(nvram get wifi_ipaddr)"
case "${REMOTE_ADDR%.*}" in
	${WIFI_IP%.*}) SERVER_URL="http://$WIFI_IP";;
	${LAN_IP%.*}) SERVER_URL="http://$LAN_IP";;
esac
cat <<EOF
			</select>
		</div>
		</form>
		<div id="content" style="padding-left: 15%; padding-right: 15%">
			<h2>@TR<<Splash_head1|Why am I seeing this Management Console instead of the FON HotSpot Access Portal?>></h2><br/>

			<p>@TR<<Splash_head2|It looks like your FON HotSpot was not able to configure itself to your home network settings. This can be due to many different reasons:>></p><br/>

			<li>@TR<<Scenario>> 1:
				<p>@TR<<Splash_scenario1|The FON HotSpot was on long before you connected the network cable. It is very important that the network is connected before turning on the FON HotSpot. Otherwise the internal auto-configuration process may fail.>></p>
				<p style="margin-top: 10px;"><strong>@TR<<Solution>>:</strong><br/>
				@TR<<Splash_solution1|Try to unplug the power cable and then plug it back in. Everything should be working in about <strong>1 minute</strong> >></p>
			</li><br/>
			<li>@TR<<Scenario>> 2:
				<p>@TR<<Splash_scenario2|One of the network cables is not properly connected.>></p>
				<p style="margin-top: 10px;"><strong>@TR<<Solution>>:</strong><br/>
				@TR<<Splash_solution2|Please, make sure that your FON HotSpot is connected as shown in the installation manual provided with your router (step 1). Once everything is connected properly, it should be working fine in about <strong>1 or 2 minutes</strong> >></p>
			</li><br/>
			<li>@TR<<Scenario>> 3:
				<p>@TR<<Splash_scenario3|Your Internet connection is temporally not working and the FON HotSpot could not auto-configure its settings.>></p>
				<p style="margin-top: 10px;"><strong>@TR<<Solution>>:</strong><br/>
				@TR<<Splash_solution3|Try your usual way of connecting to Internet and if it fails, please contact your ISP.>></p>
			</li><br/>
			<li>@TR<<Scenario>> 4:
				<p>@TR<<Splash_scenario4.1|Your home network requires some manual configuration for the FON HotSpot to work. It means FON HotSpot is unable to automatically detect your network settings.>></p>
				<p>@TR<<Splash_scenario4.2|Your network has been manually set at any moment in the past. This is why FON Hotspot is unable to detect its configuration. <strong>If you are not aware of having done any of these changes or are not used to configuring networks, please contact our customer support service on support@fon.com</strong> >></p>
				<p style="margin-top: 10px;"><strong>@TR<<Solution>>:</strong><br/>
				@TR<<Splash_solution4.1|You need to find out a valid IP address which is not being used by any other computer in your network and configure manually your FON Hotspot.>></p>
				<p>@TR<<Splash_solution4.2|To do so, please check step by step the Installation Troubleshooting Reference Manual.>></p>
				<p>@TR<<Splash_solution4.3|If you were already aware you are using static IP configuration or PPPoE and you know how this works, please click on the &quot;I want to configure my network now&quot; link below and you will be redirected to the FON HotSpot Internet connection configuration web page (WAN configuration). You will then be required for a username and password. Use the defaults unless you change them anytime in the past:<strong><br/>Username: admin<br/>Password: admin</strong><br/><strong>This password is not related to your FON username or accounts</strong>, it is just a security password to prevent unwanted users to missconfigure your FON HotSpot.>></p>
			</li><br/>
				<p><a href="$SERVER_URL/cgi-bin/webif/wan.sh$PATH_INFO">@TR<<Go_to_wan|I want to configure my network now>></a></p>
		</div>
EOF

footer
