/*
##########################################################################
##                                                                      ##
##   RENE GARCIA                          GNU General Public License V2 ##
##                                                                      ##
##########################################################################
##                                                                      ##
##      Projet  : TEMPerHum Linux                                       ##
##      Module  : DS75                                                  ##
##      Piece   : DS75.h                                                ##
##      Langage : C ANSI                                                ##
##      Auteur  : Ren GARCIA                                           ##
##                                                                      ##
##########################################################################
*/

    /*-
     *
     *  $Id: DS75.h,v 1.1 2009/10/09 08:03:24 rgarcia Exp $
     *
     *  $Log: DS75.h,v $
     *  Revision 1.1  2009/10/09 08:03:24  rgarcia
     *  Version initiale
     *
     *
    -*/

/***************************  Inclusions  *******************************/

#ifndef __DS75_H__
#define __DS75_H__

/************************************************************************
*                                                                       *
*               C O N S T A N T E S   D U   M O D U L E                 *
*                                                                       *
************************************************************************/

/* =======  Bits de configuration */

#define DS75_RESOLUTION_MASK        0x60
#define DS75_RESOLUTION_9BIT        0x00
#define DS75_RESOLUTION_10BIT       0x20
#define DS75_RESOLUTION_11BIT       0x40
#define DS75_RESOLUTION_12BIT       0x60

#define DS75_THERMOSTAT_MASK        0x18
#define DS75_THERMOSTAT_TOLE1       0x00
#define DS75_THERMOSTAT_TOLE2       0x08
#define DS75_THERMOSTAT_TOLE4       0x10
#define DS75_THERMOSTAT_TOLE6       0x18

#define DS75_THERMOSTAT_POL_MASK    0x04
#define DS75_THERMOSTAT_POL_LOW     0x00
#define DS75_THERMOSTAT_POL_HIGH    0x04

#define DS75_THERMOSTAT_MODE_MASK   0x02
#define DS75_THERMOSTAT_MODE_COMP   0x00
#define DS75_THERMOSTAT_MODE_INT    0x02

#define DS75_SHUTDOWN               0x01

/************************************************************************
*                                                                       *
*            P R O T O T Y P E S   D E S   F O N C T I O N S            *
*                                                                       *
************************************************************************/

/*=====================================================================*/
/* Lecture du registre d'tat de la sonde DS75                        */
/*=====================================================================*/

int DS75_ReadStatusReg (unsigned char, unsigned char *);

/*=====================================================================*/
/* Ecriture du registre d'tat de la sonde DS75                       */
/*=====================================================================*/

int DS75_WriteStatusReg (unsigned char, unsigned char);

/*=====================================================================*/
/* Lecture d'une mesure de temperature et d'humidit de la sonde DS75 */
/*=====================================================================*/

int DS75_GetTemp (unsigned char, double *);

#endif /* __DS75_H__ */

/* ######################  FIN DE FICHIER  ########################### */
