/*
##########################################################################
##                                                                      ##
##   RENE GARCIA                          GNU General Public License V2 ##
##                                                                      ##
##########################################################################
##                                                                      ##
##      Projet  : TEMPerHum Linux                                       ##
##      Module  : rs232                                                 ##
##      Piece   : rs232.h                                               ##
##      Langage : C ANSI                                                ##
##      Auteur  : Ren GARCIA                                           ##
##                                                                      ##
##########################################################################
*/

    /*-
     *
     *  $Id: rs232.h,v 1.1 2009/10/09 08:03:24 rgarcia Exp $
     *
     *  $Log: rs232.h,v $
     *  Revision 1.1  2009/10/09 08:03:24  rgarcia
     *  Version initiale
     *
     *
    -*/

/***************************  Inclusions  *******************************/

#ifndef __RS232_H__
#define __RS232_H__

/************************************************************************
*                                                                       *
*            P R O T O T Y P E S   D E S   F O N C T I O N S            *
*                                                                       *
************************************************************************/

/*=====================================================================*/
/* Positionne la sortie DTR de la liaison serie a la valeur souhaite  */
/*=====================================================================*/

void rs232_DTR (register int);

/*=====================================================================*/
/* Positionne la sortie RTS de la liaison serie a la valeur souhaite  */
/*=====================================================================*/

void rs232_RTS (register int);

/*=====================================================================*/
/* Lecture de l'entre CTS du port srie                               */
/*=====================================================================*/

int rs232_CTS (void);

/*=====================================================================*/
/* Initialisation du controleur de bus rs232                           */
/*=====================================================================*/

void rs232_Open (void);

/*=====================================================================*/
/* Fermeture du controleur de bus rs232                                */
/*=====================================================================*/

void rs232_Close (void);

#endif /* __RS232_H__ */

/* ######################  FIN DE FICHIER  ########################### */
