/*
##########################################################################
##                                                                      ##
##   RENE GARCIA                          GNU General Public License V2 ##
##                                                                      ##
##########################################################################
##                                                                      ##
##      Projet  : TEMPerHum Linux                                       ##
##      Module  : I2C                                                   ##
##      Piece   : I2C.h                                                 ##
##      Langage : C ANSI                                                ##
##      Auteur  : Ren GARCIA                                           ##
##                                                                      ##
##########################################################################
*/

    /*-
     *
     *  $Id: I2C.h,v 1.1 2009/10/09 08:03:24 rgarcia Exp $
     *
     *  $Log: I2C.h,v $
     *  Revision 1.1  2009/10/09 08:03:24  rgarcia
     *  Version initiale
     *
     *
    -*/

/***************************  Inclusions  *******************************/

#ifndef __I2C_H__
#define __I2C_H__

/************************************************************************
*                                                                       *
*            P R O T O T Y P E S   D E S   F O N C T I O N S            *
*                                                                       *
************************************************************************/

/*=====================================================================*/
/* Positionne la ligne d'horloge SCL au niveau souhait                */
/*=====================================================================*/

void I2C_Sclk (register int);

/*=====================================================================*/
/* Positionne la ligne de donnes SDA au niveau souhait               */
/*=====================================================================*/

void I2C_SDout (register int);

/*=====================================================================*/
/* Lecture du niveau de la ligne de donnes SDA du bus I2C             */
/*=====================================================================*/

int I2C_SDin (void);

/*=====================================================================*/
/* Realise un cycle d'horloge                                          */
/*=====================================================================*/

void I2C_HiLowSCLK (void);

/*=====================================================================*/
/* Ecriture d'un acquitement de lecture                                */
/*=====================================================================*/

void I2C_SendACK (unsigned char);

/*=====================================================================*/
/* Lecture de l'acquitement d'criture                                 */
/*=====================================================================*/

int I2C_GetACK (void);

/*=====================================================================*/
/* Ecriture d'un octet sur le bus de donnes I2C                       */
/*=====================================================================*/

void I2C_RawWrite8 (register unsigned char);

/*=====================================================================*/
/* Lecture d'un octet sur le bus de donnes I2C                        */
/*=====================================================================*/

unsigned char I2C_RawRead8 (void);

/*=====================================================================*/
/* Envoi d'une donne 8 bit sur le bus de donnes I2C                  */
/*=====================================================================*/

int I2C_Write8 (unsigned char);

/*=====================================================================*/
/* Envoi d'une donne 16 bit sur le bus de donnes I2C                 */
/*=====================================================================*/

int I2C_Write16 (unsigned short);

/*=====================================================================*/
/* Envoi d'une donne 24 bit sur le bus de donnes I2C                 */
/*=====================================================================*/

int I2C_Write24 (unsigned long);

/*=====================================================================*/
/* Lecture d'un octet  une adresse                                    */
/*=====================================================================*/

unsigned char I2C_Read8 (unsigned char);

/*=====================================================================*/
/* Lecture d'un mot de 16 bits  une adresse                           */
/*=====================================================================*/

unsigned short I2C_Read16 (unsigned char);

/*=====================================================================*/
/* Lecture d'une srie de N octets                                     */
/*=====================================================================*/

int I2C_ReadN (unsigned char, register unsigned char *, register int size);

/*=====================================================================*/
/* Initialisation du controleur de bus I2C                             */
/*=====================================================================*/

void I2C_Open (void);

/*=====================================================================*/
/* Fermeture du controleur de bus I2C                                  */
/*=====================================================================*/

void I2C_Close (void);

#endif /* __I2C_H__ */

/* ######################  FIN DE FICHIER  ########################### */
