/*
##########################################################################
##                                                                      ##
##   RENE GARCIA                          GNU General Public License V2 ##
##                                                                      ##
##########################################################################
##                                                                      ##
##      Projet  : TEMPerHum Linux                                       ##
##      Module  : TH                                                    ##
##      Piece   : TH.c                                                  ##
##      Langage : C ANSI                                                ##
##      Auteur  : Ren GARCIA                                           ##
##                                                                      ##
##########################################################################
*/

    /*-
     *
     *  $Id: TH.c,v 1.1 2009/10/09 08:03:24 rgarcia Exp $
     *
     *  $Log: TH.c,v $
     *  Revision 1.1  2009/10/09 08:03:24  rgarcia
     *  Version initiale
     *
     *
    -*/

/***************************  Inclusions  *******************************/

#include <stdio.h>
#include <math.h>
#include "TEMPer.h"

/************************************************************************
*                                                                       *
*            P R O T O T Y P E S   D E S   F O N C T I O N S            *
*                                                                       *
************************************************************************/

static double DewPoint (double xTemp, double rh_true);

/************************************************************************
*                        double DewPoint(temp,rh)                PRIVE  *
*                        ~~~~~~~~~~~~~~~~~~~~~~~~                       *
* Objet : Calcul du point de condensation                               *
*-----------------------------------------------------------------------*
* PARAMETRES                                                            *
*                                                                       *
*  temp : (double) Temprature (en C)                                  *
*  rh   : (double) Humidit relative (en %)                             *
*                                                                       *
*-----------------------------------------------------------------------*
* VALEUR DE RETOUR                                                      *
*                                                                       *
* (double) Temprature  laquelle se formera de la condensation         *
*                                                                       *
************************************************************************/

static double
DewPoint (double xTemp, double rh_true)
{
   /* Calcul */
   double logEx =
      0.66077 + 7.5 * xTemp / (237.3 + xTemp) + (log10 (rh_true) - 2.0);

   return (logEx - 0.66077) * 237.3 / (0.66077 + 7.5 - logEx);
}

/************************************************************************
***                                                                   ***
**            =   F O N C T I O N   P R I N C I P A L E   =            **
***                                                                   ***
************************************************************************/

int
main (int argc, char **argv)
{
   /* =======  Variables locales */
   double Temp,                 /* Temperature */
      Hum,                      /* Humidite relative */
      Dew;                      /* Point de condensation */

   /* =======  Debut du code */

   /* -------  Ouvrir et initialiser la sonde */
   TEMPer_Open ();

   /* -------  Lecture de la temperature et de l'humidite */
   TEMPer_Read (&Temp, &Hum);

   /* -------  Fermeture de la sonde */
   TEMPer_Close ();

   /* -------  Calcul du point de condensation */
   Dew = DewPoint (Temp, Hum);

   /* -------  Affichage des rsultats */
   printf ("temp: %f\nhum: %f\ndew: %f\n", Temp, Hum, Dew);

   return 0;
}

/* ######################  FIN DE FICHIER  ########################### */
