/*
##########################################################################
##                                                                      ##
##   RENE GARCIA                          GNU General Public License V2 ##
##                                                                      ##
##########################################################################
##                                                                      ##
##      Projet  : TEMPerHum Linux                                       ##
##      Module  : crc                                                   ##
##      Piece   : crc.c                                                 ##
##      Langage : C ANSI                                                ##
##      Auteur  : Ren GARCIA                                           ##
##                                                                      ##
##########################################################################
*/

    /*-
     *
     *  $Id: crc.c,v 1.1 2009/10/09 08:03:24 rgarcia Exp $
     *
     *  $Log: crc.c,v $
     *  Revision 1.1  2009/10/09 08:03:24  rgarcia
     *  Version initiale
     *
     *
    -*/

/***************************  Inclusions  *******************************/

#include "crc.h"

/************************************************************************
*                                                                       *
*               C O N S T A N T E S   D U   M O D U L E                 *
*                                                                       *
************************************************************************/

#define CRC_POLYNOME    0x31    /* 00110001 */
#define CRC_START       0x00    /* 00000000 */

/************************************************************************
*                                                                       *
*        V A R I A B L E S   G L O B A L E S   A U   M O D U L E        *
*                                                                       *
************************************************************************/

/* Registre de calcul du CRC (donc librairie non rentrante) */
static unsigned char CRC_Value;

/************************************************************************
*                            void crc_Init()                    PUBLIC  *
*                            ~~~~~~~~~~~~~~~                            *
* Objet : Initialisation d'un calcul de CRC                             *
*-----------------------------------------------------------------------*
* PARAMETRES                                                            *
*                                                                       *
* (aucun)                                                               *
*                                                                       *
*-----------------------------------------------------------------------*
* VALEUR DE RETOUR                                                      *
*                                                                       *
* (aucune)                                                              *
*                                                                       *
************************************************************************/

void
crc_Init (void)
{
   CRC_Value = CRC_START;
}

/************************************************************************
*                            void crc_Add(val)                  PUBLIC  *
*                            ~~~~~~~~~~~~~~~~~                          *
* Objet : Ajouter un octet au calcul du CRC                             *
*-----------------------------------------------------------------------*
* PARAMETRES                                                            *
*                                                                       *
* val : (unsigned char) Valeur  ajouter                                *
*                                                                       *
*-----------------------------------------------------------------------*
* VALEUR DE RETOUR                                                      *
*                                                                       *
* (aucune)                                                              *
*                                                                       *
************************************************************************/

void
crc_Add (register unsigned char val)
{
   /* =======  Variables locales */
   register unsigned char i;

   /* =======  Debut du code */

   /* Pour chacun des 8 bits */
   for (i = 0x80; i; i >>= 1)
   {
      /* Si bit 7 du CRC == bit de donne */
      if ((CRC_Value & 0x80) == ((val & i)?0x80:0))
      {
         /* decalage simple */
         CRC_Value <<= 1;
      }
      else
      {
         /* decalage et inversion */
         CRC_Value <<= 1;
         CRC_Value ^= CRC_POLYNOME;
      }
   }
}

/************************************************************************
*                            int crc_Check(val)                 PUBLIC  *
*                            ~~~~~~~~~~~~~~~~~~                         *
* Objet : Tester le CRC                                                 *
*-----------------------------------------------------------------------*
* PARAMETRES                                                            *
*                                                                       *
* val : (unsigned char) Valeur  tester                                 *
*                                                                       *
*-----------------------------------------------------------------------*
* VALEUR DE RETOUR                                                      *
*                                                                       *
* (int) 0 si le CRC est bon, autre valeur sinon                         *
*                                                                       *
************************************************************************/

int
crc_Check (register unsigned char val)
{
   /* =======  Variables locales */
   register unsigned char i;
   register unsigned char crc = 0;

   /* =======  Debut du code */

   /* Renversement des bits de la valeur a tester */

   /* Pour chacun des 8 bits */
   for (i = 0x80; i; i >>= 1)
   {
      /* Decalage des bits  droite */
      crc >>= 1;

      /* Si le bit a 1 copier le bit */
      if (val & i)
         crc |= 0x80;
   }

   /* Test du CRC */
   return (crc != CRC_Value);
}

/* ######################  FIN DE FICHIER  ########################### */
