/*
##########################################################################
##                                                                      ##
##   RENE GARCIA                          GNU General Public License V2 ##
##                                                                      ##
##########################################################################
##                                                                      ##
##      Projet  : TEMPerHum Linux                                       ##
##      Module  : EE2402                                                ##
##      Piece   : EE2402.c                                              ##
##      Langage : C ANSI                                                ##
##      Auteur  : Ren GARCIA                                           ##
##                                                                      ##
##########################################################################
*/

    /*-
     *
     *  $Id: EE2402.c,v 1.1 2009/10/09 08:03:24 rgarcia Exp $
     *
     *  $Log: EE2402.c,v $
     *  Revision 1.1  2009/10/09 08:03:24  rgarcia
     *  Version initiale
     *
     *
    -*/

/***************************  Inclusions  *******************************/

#include "I2C.h"
#include "EE2402.h"

/************************************************************************
*                                                                       *
*               C O N S T A N T E S   D U   M O D U L E                 *
*                                                                       *
************************************************************************/

/* =======  Identifiant du chip */
#define EE2402_ID       0xA0

/* =======  Type d'accs */
#define EE2402_READ     1
#define EE2402_WRITE    0

/************************************************************************
*                  char EE2402_ReadBytes(addr,pVal,nbr)         PUBLIC  *
*                  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                 *
* Objet : Lecture d'une srie d'octets de l'EEPROM  partir d'une       *
*         addresse                                                      *
*-----------------------------------------------------------------------*
* PARAMETRES                                                            *
*                                                                       *
*  addr : (unsigned char) Adresse de debut de lecture (0-255)           *
*  pVal : (unsigned char *) Pointeur sur la zone mmoire qui recevra    *
*         les octets lus                                                *
*  nbr  : (int) Nombre d'octets  lire                                  *
*                                                                       *
*-----------------------------------------------------------------------*
* VALEUR DE RETOUR                                                      *
*                                                                       *
* (int) 0 si tout est OK, autre valeur sinon                            *
*                                                                       *
************************************************************************/

int
EE2402_ReadBytes (unsigned char addr, unsigned char *pVal, int nbr)
{
   /* =======  Variables locales */
   int status = 0;

   /* =======  Debut du code */

   /* Selection de l'adresse de dpart */
   status += I2C_Write16 (((EE2402_ID | EE2402_WRITE) << 8) | addr);

   /* Lecture du registre de configuration */
   status += I2C_ReadN (EE2402_ID | EE2402_READ, pVal, nbr);

   /* Code retour */
   return status;
}

/************************************************************************
*                 char EE2402_WriteBytes(addr,pVal,nbr)         PUBLIC  *
*                 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                 *
* Objet : Ecriture d'une srie d'octets de l'EEPROM  partir d'une      *
*         addresse                                                      *
*-----------------------------------------------------------------------*
* PARAMETRES                                                            *
*                                                                       *
*  addr : (unsigned char) Adresse de debut d'criture (0-255)           *
*  pVal : (unsigned char *) Pointeur sur la zone mmoire a partir de    *
*         laquelle les octets seront lus                                *
*  nbr  : (int) Nombre d'octets  crire                                *
*                                                                       *
*-----------------------------------------------------------------------*
* VALEUR DE RETOUR                                                      *
*                                                                       *
* (int) 0 si tout est OK, autre valeur sinon                            *
*                                                                       *
************************************************************************/

int
EE2402_WriteBytes (unsigned char addr, unsigned char *pVal, int nbr)
{
   /* Par mesure de scurit, code non implment */
   return 1;
}

/* ######################  FIN DE FICHIER  ########################### */
